/**
 * @fileoverview All menus here, contains mouse right click and left click 
 * @author sunnyjiang
 * @version 1.1
 */

var menuManager = {};

menuManager.showMenu = function(type, menuParms) {
	browser.skin.menu.build(0, type, menuParms);
};

var menu = {};

menu.params = null;
menu.build = function(data) {
	try {
		var menuData = data[1];
		var menuId = menu.getId();
		
		
		menu.params = data[2];
		
		var menuLayer = $('#menu-layer');
		var menuElement = $('#menu');
		
		var menuUlHTML = '<ul>';
	    
		// 循环每个菜单项构造菜单
		for(var i = 0; i < menuData.length; i++) {
			var menuItem = menuData[i];
			// 因为参数传递的问题，必须要unescape两次
			var menuItemName = utils.encodeHtml(unescape(unescape(menuItem.name)));
			var menuSource = unescape(unescape(menuItem.id.source));
			var accelerator = unescape(unescape(menuItem.accelerator));

			// just for zoom menu
			if(menuSource == '{D21B044A-3FDF-4241-865C-5692771BED80}') {
				menuItemName = menuItemName.replace(/([-=+])/ig, "<span class='font-align'>$1</span>");
				accelerator = accelerator.replace(/([-=+])/ig, "<span class='font-align'>$1</span>");
			}

			// id: 每一菜单项的id
			// type：类型
			// enabled: 是否enabled
			// checked: 是否选定
			// name: 名称
			// subMenuId: 子菜单id
			// icon: 图标

			// 分隔符的处理
			if(menuItem.type == 5) {
				menuUlHTML += '<li class="hr"></li>';
				continue;
			}

			var menuItemId = unescape(unescape(JSON.stringify(menuItem.id)));
			var liClasses = [], liAttributes = {}, liStyle = '';
			if(menuItem.checked == 1) {
				liClasses.push('checkbox-checked');
			}
			var liOnclick = (menuItem.subMenuId || !menuItem.enabled) ? ' ' : ' onclick=\'menu.click(' + menuId + ',' + menuItemId + ',"' + menuItemName.replace(/"/g, '\\"') + '")\'';

			if(!menuItem.enabled) {
				liClasses.push('disabled');
			} else if(menuItem.subMenuId) {// 该菜单项enabled，并且有子菜单
				liClasses.push('parent');
				liAttributes.submenuid = menuItem.subMenuId;
			}

			var iconHTML = "";

			if(menuItem.icon == "default_icon") {
				iconHTML = "<img src='images/tab/QBrowserDefault.png' />";
			} else if(menuItem.icon != "") {
                 var timeStamp = new Date().getTime();
				iconHTML = "<img src='" + unescape(menuItem.icon)+" '/>";
			}
			
			// 热键处理
			var hotKeyHTML = accelerator != '' ? '<span class="hot-key">' + accelerator + '</span>' : '';
			
			/*
			if (menuItemName.indexOf("&") > -1) {
				// 热键添加后的显示处理问题
				var index = menuItemName.indexOf('&');
				var hotkey = menuItemName.substring(index, index + 1);
				menuItemName = menuItemName.replace(/&([A-Z])/, '<span>$1</span>');
				var id = menuId;
				var itemId = JSON.parse(menuItemId);
				$(document.body).bind('keydown', function() {
					if (event.keyCode == 84) {
						menu.click(id, itemId);
					}
				});
			}*/

			
			if(liClasses.length > 0) {
				liStyle = ' class="' + liClasses.join(' ') + '"';
			}
			
			if(liAttributes.submenuid) {
				liStyle += ' submenuid="' + liAttributes.submenuid + '"';
			}
			
			menuUlHTML +=
				'<li' + liStyle + liOnclick + '>' +
					iconHTML + menuItemName + hotKeyHTML +
				'</li>';
		}
		menuUlHTML += '</ul>';
		menuElement.html(menuUlHTML);
		
		keyHandler.markIndex();
		menuElement.show();

		$('li:not(.hr, .disabled)', menuElement).bind('mouseover', function() {
			if ($(this).is('.highlight')) {
				return;
			}
			
			// 当前菜单的其它菜单项取消高亮
			$('.highlight').removeClass('highlight');
			
			menu.hover(this);
		});
		/*
		.bind('mouseleave', function() { // 需要判断是否移到子菜单了
			$(this).removeClass('highlight');
		});
		*/

		var menuSize = view.getSize('menu');

		qqbrowser.skin.menu.show(menuId, menuSize.width, menuSize.height);

	} catch(e) {}
};

menu.click = function(menuId, menuItemId, menuItemName) {
	if (menuItemName === '添加到收藏夹' || menuItemName === '整理收藏夹') {
		qqbrowser.account.getLoginState(function(state) {
			// 1 未登录
			// 2 登录
			// 3 离线状态—伪登陆状态
			state = JSON.parse(state)[0];
			
			// 离线状态
			if (state == 3) {
				qqbrowser.extension.sendRequest('{80944EE7-D5ED-46f6-86DF-53FCE8B945AB}', {
					command: 'BOOKMARK_READONLY_NOTIFICATION'
				}, function() {});
				qqbrowser.skin.menu.hideAll(menu.getId());
			} else {
				qqbrowser.skin.menu.click(menuId, menuItemId, menu.params);
			}
		});
	} else {
		qqbrowser.skin.menu.click(menuId, menuItemId, menu.params);
	}
};

/**
 * hover on a menu element 
 */
menu.hover = function(element) {
	$('.highlight').removeClass('highlight');
	
	// 获取li
	var element = $(element);
	element.addClass('highlight');
	
	// 取消上一个展开的
	var parentId = menu.getId();
	browser.skin.menu.hideSubMenu(parentId);
	
	
	// 如果是parent，绑定showchildmenu，否则隐藏
	if(element.hasClass('parent') ) {
		var subMenuId = parseInt(element.attr('submenuid')),
			clientRect = element[0].getBoundingClientRect(),
			rect = {
				leftBottomX: clientRect.left,
				leftBottomY: clientRect.bottom,
				rightTopX: clientRect.right,
				rightTopY: clientRect.top
			};

		// 系统菜单的收藏菜单
		if (subMenuId == 11 || subMenuId == 15) {
			MenuFactory.createBookmarkMenu(MENU_TYPE.MENUBAR_BOOKMARK, null, {parentMenuId: parentId, rect: rect, 'element': element, isSubMenu: true});
		} else {
			menuManager.showMenu(subMenuId, {parentId: parentId, location: rect});
		}
	}
};

/**
 * charge a menu display or not
 */
menu.isDisplay = function(type) {
	return false;
/*	var ul = $('#menu-layer ul');
	if(ul.attr('type') == type && ul.css('display') == 'block')
		return true;
	return false;*/
};

/**
 * get menu type
 */
menu.getType = function() {
//	alert(location.href);
};

/**
 * get id, for tab menu
 */
menu.getId = function() {
//	return $('#menu ul').attr('sourceId');
	return parseInt(utils.parseUrl().id);
};

/**
 * get menu id, for tab menu
 */
menu.getMenuId = function() {
//	return $('#menu ul').attr('sourceId');
	return parseInt(utils.parseUrl().menuId);
};

/**
 * init all menus
 */
menu.init = function() {
//	var type = menu.getType();
	var id = menu.getId();

	// 从浏览器获取数据
	browser.skin.menu.init(id, function(menuDataJson) {
		var menuData = JSON.parse(menuDataJson),
			envVars = menuData[1][0];
		
	});
};

var keyHandler={
	markIndex:function(){
		var cnt=0;	  
		$('li:not(.hr)').each(function(ind,item){
				$(item).attr('index',ind);
				cnt++;
		});	      
		keyHandler.totli = cnt;
	},
	doEnter:function() {
		menu.hover($('li.highlight')[0]);
		$('li.highlight').click();
	},
	doLeft:function(){
		qqbrowser.skin.menu.hide(menu.getId());		     
	},
	doUp:function(){	   
		var selected=document.querySelector('li.highlight');
		var index=0;
		if (selected){
			index = $(selected).attr('index');
			index = parseInt(index);
			index=(index-1+keyHandler.totli)%(keyHandler.totli);
		}
		
		keyHandler.selectedTo(index);
	},
	doRight:function(){
		var selected=document.querySelector('li.highlight');
		var index=0;
		if (selected){
			index = $(selected).attr('index');
			index = parseInt(index);
		}
		var aim = $('li[index='+index+']');
		var parentId = menu.getId();
		browser.skin.menu.hideSubMenu(parentId);
		if(aim.hasClass('parent') ) {
			var subMenuId = parseInt(aim.attr('submenuid')),
				clientRect = aim[0].getBoundingClientRect(),
				rect = {
					leftBottomX: clientRect.left,
					leftBottomY: clientRect.bottom,
					rightTopX: clientRect.right,
					rightTopY: clientRect.top
				};

			if (subMenuId == 11 || subMenuId == 15) {
				MenuFactory.createBookmarkMenu(MENU_TYPE.MENUBAR_BOOKMARK, null, {parentMenuId: parentId, rect: rect, 'element': selected, isSubMenu: true});
			} else {
				menuManager.showMenu(subMenuId, {parentId: parentId, location: rect});
			}
			// 建立子菜单时，将当前的中的li元素传进去，解决用方向键选择菜单时的位置显示不正确的问题
			
		}		
	},
	doDown:function(){
		var selected=document.querySelector('li.highlight');
		var index=0;
		if (selected){
			index = $(selected).attr('index');
			index = parseInt(index);
			index=(index+1)%(keyHandler.totli);
		}
		$(selected).removeClass('highlight');
		keyHandler.selectedTo(index);
	},
	selectedTo:function(index){
		$('.highlight').removeClass('highlight');
		var aim = $('li[index='+index+']');
		aim.addClass('highlight');		
	}
};
$(function() {
	document.onselectstart = document.ondragstart = function() {
		return false;
	};	

	$(document.body).bind('keydown', function() {
		if(event.keyCode == 27) {
			qqbrowser.skin.menu.hide(menu.getId());
		}

		if(event.keyCode == 65 && event.ctrlKey) {
			event.preventDefault();
		}
		switch(event.keyCode){
			case 13:
				keyHandler.doEnter();
				break;
			case 37:
				keyHandler.doLeft();
			     break;
			case 38:
			     	keyHandler.doUp();
			     break;
			case 39:
			     	keyHandler.doRight();
			     break;
			case 40:
			     	keyHandler.doDown();
			     break;
		}
	});
	
	if(browser.isPage()) { // only for page test
	} else {
		menu.init();	
	}
});
